﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;

namespace Ending_Balance
{
    public partial class Form1 : Form
    {
        public Form1()
        {
            InitializeComponent();
        }

        private void calculateButton_Click(object sender, EventArgs e)
        {
            // Stała określająca miesięczną stopę procentową. 
            const decimal INTEREST_RATE = 0.005m;
            
            // Zmienne lokalne. 
            decimal balance;    //  Saldo konta. 
            int months;         //  Liczba miesięcy. 
            int count = 1;      //  Licznik pętli zainicjalizowany wraz z wartością 1.
            
            // Pobranie salda początkowego. 
            if (decimal.TryParse(startingBalTextBox.Text, out balance))
            {
                // Pobranie liczby miesięcy. 
                if (int.TryParse(monthsTextBox.Text, out months))
                {
                    // Ta pętla oblicza wysokość salda końcowego.
                    while (count <= months)
                    {
                        // Dodanie do wysokości salda odsetek za dany miesiąc. 
                        balance = balance + (INTEREST_RATE * balance);
                        
                        // Dodanie wartości 1 do licznika pętli. 
                        count = count + 1;
                    }
                    
                    // Wyświetlenie salda końcowego. 
                    endingBalanceLabel.Text = balance.ToString("c");
                }
                else 
                {
                    // Została podana nieprawidłowa liczba miesięcy. 
                    MessageBox.Show("Nieprawidłowa liczba miesięcy.");
                }
            }
            else 
            {
                // Została podana nieprawidłowa wysokość salda początkowego. 
                MessageBox.Show("Nieprawidłowa wartość salda początkowego.");
            }
        }

        private void clearButton_Click(object sender, EventArgs e)
        {
            // Usunięcie zawartości kontrolek TextBoxes i Label.
            startingBalTextBox.Text = "";
            monthsTextBox.Text = "";
            endingBalanceLabel.Text = "";
            
            // Uaktywnienie kontrolki startingBalTextBox. 
            startingBalTextBox.Focus();
        }

        private void exitButton_Click(object sender, EventArgs e)
        {
            // Zamknięcie formularza. 
            this.Close();
        }
    }
}
